#!/bin/bash
cd "$(dirname "$0")"
test_csv=results/results_stats_history.csv

echo 'Formatting locust test'

tr -d '\r' < $test_csv > temp && mv temp $test_csv
sed -i '/,N\/A/d' $test_csv                     # remove lines without metrics
sed -i '1s/$/,COMPONENT/' $test_csv             # add component header
sed -i '2,$s/$/,application/' $test_csv         # add component value
awk -F, 'NR>1 { $1=strftime("%Y-%m-%d %H:%M:%S", $1); print } NR==1 { print }' OFS=, $test_csv > temp && mv temp $test_csv # format timestamp

echo 'Locust test formatted'